#include <Liquid_Crystal.h>                                    //Βιβλιοθήκη οθόνης

LiquidCrystal myLCD(0x27, 16, 2);                              // Έναρξη της LCD. Η σύνδεση πρέπει να γίνει στη θύρα I2C του Arduino

const int Humidity_Pin = A0;                                   // Θύρα για τον αισθητήρα υγρασίας εδάφους
int sensorValue;                                               // Μεταβλητή για την αποθήκευση της τιμής του αισθητήρα
int humidityPercentage;                                        // Μεταβλητή για την αποθήκευση της υγρασίας σε ποσοστό %

void setup() 
{
    myLCD.begin();                                             // Εκκίνηση της LCD
}

void loop() 
{ 
    sensorValue = analogRead(Humidity_Pin);                    // Διαβάζουμε την αναλογική τιμή από τον αισθητήρα υγρασίας (τιμές από 0-1023  -  0: 0V και 1023: 5V)
    
    humidityPercentage = map(sensorValue, 0, 1023, 0, 100);    // Μετατροπή της τιμής 0-1023 σε ποσοστό 0-100

    myLCD.Text("H=   ", 0, 0);                                 // Εμφάνιση κειμένου στην πρώτη γραμμή
    myLCD.Text(String(humidityPercentage).c_str(), 2, 0);      // Εμφάνιση ποσοστού υγρασίας
    myLCD.Text("%", 5, 0);                                     // Εμφάνιση του συμβόλου %

    delay(1000);                                               // Καθυστέρηση 1s για σταθερότητα
}
